import { system, world, ItemStack, EquipmentSlot } from "@minecraft/server";

world.beforeEvents.worldInitialize.subscribe(initEvent => {
  initEvent.blockComponentRegistry.registerCustomComponent("fm:block_interact", {
    onPlayerInteract(eventData) {
        
      const player = eventData.player;
      const block = eventData.block;
      const dimension = eventData.dimension
      const equippable = player?.getComponent("minecraft:equippable");
      const item = equippable.getEquipmentSlot(EquipmentSlot.Mainhand);
      let itemInHand = eventData.itemStack;
    
//Mana generator On

      if (block.typeId === 'fm:mana_generator') {
           if (item.typeId === 'fm:evil_amulet') {
        system.run(() => {
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run function mana_generator`);
        });}
      }
//Mana generator off
      if (block.typeId === 'fm:mana_generator_on') {
        system.run(() => {
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run function mana_generator_off`);
        });
      }
      
//collector
      if (block.typeId === 'fm:mana_c') {
        
        system.run(() => {
         block.setType("fm:mana_c_1");
         block.dimension.spawnParticle("mob:block_on", block.center());
         block.dimension.spawnParticle("mob:block_on", block.center());
         block.dimension.spawnParticle("mob:block_on", block.center());
        });
      }
      if (block.typeId === 'fm:mana_c_5') {
          if (item.typeId === 'minecraft:bucket') {
        system.run(() => {
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p bucket 0 1`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run give @p fm:mana_bucket 1`);
          block.dimension.playSound("cauldron.fillwater", block.center());
          block.setType("fm:mana_c_1");
        });}
      }
      
//Cold collector     

      if (block.typeId === 'fm:mana_c') {
          if (item.typeId === 'fm:cold_aura_pattern') {
        system.run(() => {
         block.setType("fm:mana_c_cold1");
         player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:cold_aura_pattern 0 1`);
         block.dimension.spawnParticle("mob:block_on", block.center());
         block.dimension.spawnParticle("mob:block_on", block.center());
         block.dimension.spawnParticle("mob:block_on", block.center());
        });}
      }
      if (block.typeId === 'fm:mana_c_cold') {
        system.run(() => {
         block.setType("fm:mana_c_cold1");
         dimension.spawnItem(new ItemStack("fm:cold_aura", 1), block.center());
         block.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run teleport @e[type=fm:item_cold_aura,r=1] ~ ~-1000~`);
         block.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run summon fm:kill2 ~ ~-1000 ~`);
        });
      }
      
//Dark collector

      if (block.typeId === 'fm:mana_c') {
          if (item.typeId === 'fm:dark_aura_pattern') {
        system.run(() => {
         block.setType("fm:mana_c_dark1");
         player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:dark_aura_pattern 0 1`);
         block.dimension.spawnParticle("mob:block_on", block.center());
         block.dimension.spawnParticle("mob:block_on", block.center());
         block.dimension.spawnParticle("mob:block_on", block.center());
        });}
      }
      if (block.typeId === 'fm:mana_c_dark') {
        system.run(() => {
         block.setType("fm:mana_c_dark1");
         dimension.spawnItem(new ItemStack("fm:dark_aura", 1), block.center());
         block.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run teleport @e[type=fm:item_dark_aura,r=1] ~ ~-1000~`);
         block.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run summon fm:kill2 ~ ~-1000 ~`);
        });
      }
      
//Empty collector

      if (block.typeId === 'fm:mana_c') {
          if (item.typeId === 'fm:empty_aura_pattern') {
        system.run(() => {
         block.setType("fm:mana_c_empty1");
         player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:empty_aura_pattern 0 1`);
         block.dimension.spawnParticle("mob:block_on", block.center());
         block.dimension.spawnParticle("mob:block_on", block.center());
         block.dimension.spawnParticle("mob:block_on", block.center());
        });}
      }
      if (block.typeId === 'fm:mana_c_empty') {
        system.run(() => {
         block.setType("fm:mana_c_empty1");
         dimension.spawnItem(new ItemStack("fm:e_aura", 1), block.center());
         block.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run teleport @e[type=fm:item_empty_aura,r=1] ~ ~-1000~`);
         block.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run summon fm:kill2 ~ ~-1000 ~`);
        });
      }
      
//Fire collector

      if (block.typeId === 'fm:mana_c') {
          if (item.typeId === 'fm:fire_aura_pattern') {
        system.run(() => {
         block.setType("fm:mana_c_fire1");
         player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:fire_aura_pattern 0 1`);
         block.dimension.spawnParticle("mob:block_on", block.center());
         block.dimension.spawnParticle("mob:block_on", block.center());
         block.dimension.spawnParticle("mob:block_on", block.center());
        });}
      }
      if (block.typeId === 'fm:mana_c_fire') {
        system.run(() => {
         block.setType("fm:mana_c_fire1");
         dimension.spawnItem(new ItemStack("fm:fire_aura", 1), block.center());
         block.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run teleport @e[type=fm:item_fire_aura,r=1] ~ ~-1000~`);
         block.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run summon fm:kill2 ~ ~-1000 ~`);
        });
      }
      
//Light collector

      if (block.typeId === 'fm:mana_c') {
          if (item.typeId === 'fm:light_aura_pattern') {
        system.run(() => {
         block.setType("fm:mana_c_light1");
         player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:light_aura_pattern 0 1`);
         block.dimension.spawnParticle("mob:block_on", block.center());
         block.dimension.spawnParticle("mob:block_on", block.center());
         block.dimension.spawnParticle("mob:block_on", block.center());
        });}
      }
      if (block.typeId === 'fm:mana_c_light') {
        system.run(() => {
         block.setType("fm:mana_c_light1");
         dimension.spawnItem(new ItemStack("fm:l_aura", 1), block.center());
         block.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run teleport @e[type=fm:item_light_aura,r=1] ~ ~-1000~`);
         block.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run summon fm:kill2 ~ ~-1000 ~`);
        });
      }
      
//Nature collector

      if (block.typeId === 'fm:mana_c') {
          if (item.typeId === 'fm:nature_aura_pattern') {
        system.run(() => {
         block.setType("fm:mana_c_nature1");
         player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:nature_aura_pattern 0 1`);       
         block.dimension.spawnParticle("mob:block_on", block.center());
         block.dimension.spawnParticle("mob:block_on", block.center());
         block.dimension.spawnParticle("mob:block_on", block.center());
        });}
      }
      
//Altar on    

      if (block.typeId === 'fm:altar') {
          if (item.typeId === 'fm:l_aura') {
        system.run(() => {
         block.setType("fm:altar_on");
         player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:l_aura 0 1`);
         block.dimension.playSound("mob.mana_gen_on", block.center());
         block.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run summon fm:item_light_aura2 ~ ~0.4 ~`);
        });}
      }
      if (block.typeId === 'fm:altar') {
          if (item.typeId === 'fm:e_aura') {
        system.run(() => {
         block.setType("fm:altar_on");
         player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:e_aura 0 1`);
         block.dimension.playSound("mob.mana_gen_on", block.center());
         block.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run summon fm:item_empty_aura3 ~ ~0.4 ~`);
        });}
      }
            
      if (block.typeId === 'fm:altar') {
          if (item.typeId === 'fm:nature_aura') {
        system.run(() => {
         block.setType("fm:altar_on");
         player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:nature_aura 0 1`);         
         block.dimension.playSound("mob.mana_gen_on", block.center());
         block.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run summon fm:item_nature_aura2 ~ ~0.4 ~`);
        });}
      }            
      if (block.typeId === 'fm:altar') {
          if (item.typeId === 'fm:fire_aura') {
        system.run(() => {
         block.setType("fm:altar_on");
         player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:fire_aura 0 1`);         
         block.dimension.playSound("mob.mana_gen_on", block.center());
         block.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run summon fm:item_fire_aura2 ~ ~0.4 ~`);
        });}
      }            
      if (block.typeId === 'fm:altar') {
          if (item.typeId === 'fm:dark_aura') {
        system.run(() => {
         block.setType("fm:altar_on");
         player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:dark_aura 0 1`);         
         block.dimension.playSound("mob.mana_gen_on", block.center());
         block.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run summon fm:item_dark_aura2 ~ ~0.4 ~`);
        });}
      }            
      if (block.typeId === 'fm:altar') {
          if (item.typeId === 'fm:cold_aura') {
        system.run(() => {
         block.setType("fm:altar_on");
         player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:cold_aura 0 1`);         
         block.dimension.playSound("mob.mana_gen_on", block.center());
         block.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run summon fm:item_cold_aura2 ~ ~0.4 ~`);
        });}
      }
//Altar off      
      if (block.typeId === 'fm:altar_on') {
          if (item.typeId === 'minecraft:flint_and_steel') {
        system.run(() => {
         block.dimension.playSound("fire.fire", block.center());
         block.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run function altar`);
         block.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run function a_12`);
         block.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run summon fm:kill2 ~~-1000~`);
        });}
      }
      
           
      if (block.typeId === 'fm:altar_on') {

        system.run(() => {
         block.setType("fm:altar");
         block.dimension.playSound("mob.mana_gen_on", block.center());
         block.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run function drop`);
        block.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run summon fm:kill2 ~~-1000~`);
        block.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run tp @e[family=c_auras,r=1] ~ ~-1000 ~`);
        });
      }
      
//Crucible

      if (block.typeId === 'mob:cauldron') {
          if (item.typeId === 'minecraft:water_bucket') {
        system.run(() => {
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run replaceitem entity @p slot.weapon.mainhand 0 bucket 1`);
          block.dimension.playSound("cauldron.fillwater", block.center());
          block.setType("fm:cauldron_water");
        });}
      }
      if (block.typeId === 'fm:cauldron_on') {
          if (item.typeId === 'fm:magic_stick') {
        system.run(() => {
         player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:magic_stick 0 1`);            
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ fire run setblock ~~~ fm:cauldron_f_dusty`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ campfire run setblock ~~~ fm:cauldron_f_dusty`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ lava run setblock ~~~ fm:cauldron_f_dusty`);
          block.dimension.playSound("cauldron.fillwater", block.center());
        });}
      }
      if (block.typeId === 'fm:cauldron_on') {
          if (item.typeId === 'fm:thaulum_ingot') {
        system.run(() => {
         player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:thaulum_ingot 0 1`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ fire run setblock ~~~ fm:cauldron_dark_blood_rune1`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ campfire run setblock ~~~ fm:cauldron_dark_blood_rune1`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ lava run setblock ~~~ fm:cauldron_dark_blood_rune1`);
          block.dimension.playSound("cauldron.fillwater", block.center());
        });}
      }
      if (block.typeId === 'fm:cauldron_on') {
          if (item.typeId === 'minecraft:gold_ingot') {
        system.run(() => {
         player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p gold_ingot 0 1`);            
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ fire run setblock ~~~ fm:cauldron_gold1`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ campfire run setblock ~~~ fm:cauldron_gold1`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ lava run setblock ~~~ fm:cauldron_gold1`);
          block.dimension.playSound("cauldron.fillwater", block.center());
        });}
      }
      if (block.typeId === 'fm:cauldron_on') {
          if (item.typeId === 'fm:blood_botle') {
        system.run(() => {
         player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:blood_botle 0 1`);            
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ fire run setblock ~~~ fm:cauldron_thaulum`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ campfire run setblock ~~~ fm:cauldron_thaulum`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ lava run setblock ~~~ fm:cauldron_thaulum`);
          block.dimension.playSound("cauldron.fillwater", block.center());
        });}
      }
      if (block.typeId === 'fm:cauldron_f_dusty') {
          if (item.typeId === 'fm:fairy_dust') {
        system.run(() => {
         player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:fairy_dust 0 1`);            
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ fire run setblock ~~~ fm:cauldron_mystic_flower`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ campfire run setblock ~~~ fm:cauldron_mystic_flower`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ lava run setblock ~~~ fm:cauldron_mystic_flower`);
          block.dimension.playSound("cauldron.fillwater", block.center());
        });}
      }
      if (block.typeId === 'fm:cauldron_mystic_flower') {
          if (item.typeId === 'fm:mystic_flower_hr') {
        system.run(() => {
         player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:mystic_flower_hr 0 1`);            
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ fire run setblock ~~~ fm:cauldron_pestle1`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ campfire run setblock ~~~ fm:cauldron_pestle1`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ lava run setblock ~~~ fm:cauldron_pestle1`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ fire run summon mob:pestle1 ~ ~0.51 ~`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ campfire run summon mob:pestle1 ~ ~0.51 ~`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ lava run summon mob:pestle1 ~ ~0.51 ~`);
          block.dimension.playSound("cauldron.fillwater", block.center());
        });}
      }
      if (block.typeId === 'fm:cauldron_pestle1') {
          if (!itemInHand) {
          system.run(() => {
          block.dimension.playSound("bucket.empty_water", block.center());
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run playanimation @e[type=mob:pestle1,r=1] animation.cauldron.pestle`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ fire run setblock ~~~ fm:cauldron_broom_search`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ campfire run setblock ~~~ fm:cauldron_broom_search`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ lava run setblock ~~~ fm:cauldron_broom_search`);
        });}
      }
      if (block.typeId === 'fm:cauldron_broom_search') {
          if (item.typeId === 'fm:flying_broom_search') {
        system.run(() => {
         player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:flying_broom_search 0 1`);
          block.dimension.playSound("cauldron.fillwater", block.center());
          block.setType("mob:cauldron");
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ lava run function broom_craft`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ fire run function broom_craft`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ campfire run function broom_craft`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run tp @e[type=mob:pestle1,r=1] ~ ~-1000 ~`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run summon fm:kill2 ~ ~-1000 ~`);
        });}
      }
      
//Collector      
      
      if (block.typeId === 'fm:mana_c_nature') {
        system.run(() => {
         block.setType("fm:mana_c_nature1");
         dimension.spawnItem(new ItemStack("fm:nature_aura", 1), block.center());
         block.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run teleport @e[type=fm:item_nature_aura,r=1] ~ ~-1000~`);
         block.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run summon fm:kill2 ~ ~-1000 ~`);
        });
      }
      if (block.typeId === 'fm:cauldron_dark_blood_rune1') {
          if (item.typeId === 'fm:dark_blood_rune') {
        system.run(() => {
         player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:dark_blood_rune 0 1`);             
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ fire run setblock ~~~ fm:cauldron_dark_blood_rune2`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ campfire run setblock ~~~ fm:cauldron_dark_blood_rune2`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ lava run setblock ~~~ fm:cauldron_dark_blood_rune2`);
          block.dimension.playSound("cauldron.fillwater", block.center());
        });}
        }
        if (block.typeId === 'fm:cauldron_dark_blood_rune2') {
            if (item.typeId === 'fm:dark_blood_rune') {
        system.run(() => {
         player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:dark_blood_rune 0 1`);        
          block.setType("mob:cauldron");
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ fire run function nether_star_craft`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ campfire run function nether_star_craft`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ lava run function nether_star_craft`);
          block.dimension.playSound("cauldron.fillwater", block.center());
        });}
        }
        if (block.typeId === 'fm:cauldron_gold1') {
            if (item.typeId === 'minecraft:gold_ingot') {
        system.run(() => {
         player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p gold_ingot 0 1`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ fire run setblock ~~~ fm:cauldron_chromerite`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ campfire run setblock ~~~ fm:cauldron_chromerite`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ lava run setblock ~~~ fm:cauldron_chromerite`);
          block.dimension.playSound("cauldron.fillwater", block.center());
        });}
        }
        if (block.typeId === 'fm:cauldron_chromerite') {
            if (item.typeId === 'fm:chromerite_shards') {
        system.run(() => {
         player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:chromerite_shards 0 1`);            
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ fire run setblock ~~~ fm:cauldron_pestle_2`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ campfire run setblock ~~~ fm:cauldron_pestle_2`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ lava run setblock ~~~ fm:cauldron_pestle_2`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ fire run summon mob:pestle1 ~ ~0.51 ~`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ campfire run summon mob:pestle1 ~ ~0.51 ~`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ lava run summon mob:pestle1 ~ ~0.51 ~`);
          block.dimension.playSound("cauldron.fillwater", block.center());
        });}
        }
        if (block.typeId === 'fm:cauldron_pestle_2') {
        
        system.run(() => {
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run playanimation @e[type=mob:pestle1,r=1] animation.cauldron.pestle`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ fire run setblock ~~~ fm:cauldron_void`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ campfire run setblock ~~~ fm:cauldron_void`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ lava run setblock ~~~ fm:cauldron_void`);
          block.dimension.playSound("bucket.empty_water", block.center());
        });
        }
        if (block.typeId === 'fm:cauldron_void') {
            if (item.typeId === 'fm:essence_of_void') {
        system.run(() => {
         player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:essence_of_void 0 1`);               
          block.setType("mob:cauldron");
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ fire run function thaulum_craft`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ campfire run function thaulum_craft`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ lava run function thaulum_craft`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run tp @e[type=mob:pestle1,r=1] ~ ~-1000 ~`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run summon fm:kill2 ~ ~-1000 ~`);
          block.dimension.playSound("cauldron.fillwater", block.center());
        });}
        }
        if (block.typeId === 'fm:cauldron_thaulum') {
            if (item.typeId === 'fm:thaulum_ingot') {
        system.run(() => {
         player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:thaulum_ingot 0 1`);               
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ fire run setblock ~~~ fm:cauldron_f_stone`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ campfire run setblock ~~~ fm:cauldron_f_stone`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ lava run setblock ~~~ fm:cauldron_f_stone`);
          block.dimension.playSound("cauldron.fillwater", block.center());
        });}
        }
        if (block.typeId === 'fm:cauldron_f_stone') {
            if (item.typeId === 'fm:philosophical_stone') {
        system.run(() => {
         player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:philosophical_stone 0 1`);               
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ fire run setblock ~~~ fm:cauldron_pestle_3`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ campfire run setblock ~~~ fm:cauldron_pestle_3`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ lava run setblock ~~~ fm:cauldron_pestle_3`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ fire run summon mob:pestle1 ~ ~0.51 ~`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ lava run summon mob:pestle1 ~ ~0.51 ~`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ campfire run summon mob:pestle1 ~ ~0.51 ~`);
          block.dimension.playSound("cauldron.fillwater", block.center());
        });}
        }
        if (block.typeId === 'fm:cauldron_pestle_3') {
        system.run(() => {
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ fire run setblock ~~~ fm:cauldron_void_2`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ campfire run setblock ~~~ fm:cauldron_void_2`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ lava run setblock ~~~ fm:cauldron_void_2`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run playanimation @e[type=mob:pestle1,r=1] animation.cauldron.pestle`);
          block.dimension.playSound("bucket.empty_water", block.center());
        });
        }
        if (block.typeId === 'fm:cauldron_void_2') {
            if (item.typeId === 'fm:essence_of_void') {
        system.run(() => {
         player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:essence_of_void 0 1`);    
          block.setType("mob:cauldron");
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ fire run function black_iron_craft`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ campfire run function black_iron_craft`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run execute if block ~~-1~ lava run function black_iron_craft`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run tp @e[type=mob:pestle1,r=1] ~ ~-1000 ~`);
          player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run summon fm:kill2 ~ ~-1000 ~`);
          block.dimension.playSound("bucket.empty_water", block.center());
        });}
        }
        
//Altar of sacrifice

        if (block.typeId === 'fm:altar_of_sacrifice') {
            if (item.typeId === 'fm:ritualistic_dagger') {
        system.run(() => {
        block.setType("fm:altar_of_sacrifice_stage1");
        block.dimension.playSound("mob.knife", block.center());
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run damage @p 6 magic`);
        });}
        }
        if (block.typeId === 'fm:altar_of_sacrifice_stage1') {
            if (item.typeId === 'fm:ritualistic_dagger') {
        system.run(() => {
        block.setType("fm:altar_of_sacrifice_stage2");
        block.dimension.playSound("mob.knife", block.center());
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run damage @p 6 magic`);
        });}
        }
        if (block.typeId === 'fm:altar_of_sacrifice_stage2') {
            if (item.typeId === 'fm:ritualistic_dagger') {
        system.run(() => {
        block.setType("fm:altar_of_sacrifice_stage3");
        block.dimension.playSound("mob.knife", block.center());
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run damage @p 6 magic`);
        });}
        }
        if (block.typeId === 'fm:altar_of_sacrifice_stage3') {
            if (item.typeId === 'minecraft:glass_bottle') {
        system.run(() => {
        block.setType("fm:altar_of_sacrifice");
        block.dimension.playSound("bucket.empty_water", block.center());
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run give @p fm:blood_botle`);
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p glass_bottle 0 1`);
        });}
        }
        if (block.typeId === 'fm:altar_of_sacrifice_stage3') {
            if (item.typeId === 'fm:dark_rune') {
        system.run(() => {
        block.setType("fm:altar_of_sacrifice_stage2");
        block.dimension.playSound("bucket.empty_water", block.center());
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run give @p fm:dark_blood_rune`);
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:dark_rune 0 1`);
        });}
        }
        if (block.typeId === 'fm:altar_of_sacrifice_stage3') {
            if (item.typeId === 'fm:earth_rune') {
        system.run(() => {
        block.setType("fm:altar_of_sacrifice_stage2");
        block.dimension.playSound("bucket.empty_water", block.center());
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run give @p fm:earth_blood_rune`);
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:earth_rune 0 1`);
        });}
        }
        if (block.typeId === 'fm:altar_of_sacrifice_stage3') {
            if (item.typeId === 'fm:fire_rune') {
        system.run(() => {
        block.setType("fm:altar_of_sacrifice_stage2");
        block.dimension.playSound("bucket.empty_water", block.center());
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run give @p fm:fire_blood_rune`);
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:fire_rune 0 1`);
        });}
        }
        if (block.typeId === 'fm:altar_of_sacrifice_stage3') {
            if (item.typeId === 'fm:ice_rune') {
        system.run(() => {
        block.setType("fm:altar_of_sacrifice_stage2");
        block.dimension.playSound("bucket.empty_water", block.center());
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run give @p fm:ice_blood_rune`);
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:ice_rune 0 1`);
        });}
        }
        if (block.typeId === 'fm:altar_of_sacrifice_stage3') {
            if (item.typeId === 'fm:light_rune') {
        system.run(() => {
        block.setType("fm:altar_of_sacrifice_stage2");
        block.dimension.playSound("bucket.empty_water", block.center());
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run give @p fm:light_blood_rune`);
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:light_rune 0 1`);
        });}
        }
        if (block.typeId === 'fm:altar_of_sacrifice_stage3') {
            if (item.typeId === 'fm:salt') {
        system.run(() => {
        block.setType("fm:altar_of_sacrifice");
        block.dimension.playSound("bucket.empty_water", block.center());
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run give @p fm:demonsalt`);
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:salt 0 1`);
        });}
        }
        if (block.typeId === 'mob:cthulhu_totem') {
            if (item.typeId === 'fm:cthulhu_search') {
        system.run(() => {
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:cthulhu_search 0 1`);
        block.setType("minecraft:air");
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run function summon_ct`);
        });}
        }
        
//Magic Forge
        
        if (block.typeId === 'fm:magic_forge') {
            if (item.typeId === 'minecraft:lava_bucket') {
        system.run(() => {
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p lava_bucket 0 1`);            
        block.setType("fm:magic_forgeative");
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run particle mob:flame ~ ~0.6 ~`);
        block.dimension.playSound("bucket.empty_lava", block.center());
        });}
        }
        if (block.typeId === 'fm:magic_forgeative') {
            if (item.typeId === 'mob:black_iron_block') {
        system.run(() => {
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p mob:black_iron_block 0 1`);                  
        block.setType("fm:forge2");
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run particle mob:flame ~ ~0.7 ~`);
        block.dimension.playSound("block.furnace.lit", block.center());
        });}
        }
        if (block.typeId === 'fm:forge2') {
            if (item.typeId === 'minecraft:iron_block') {
        system.run(() => {
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p iron_block 0 1`);              
        block.setType("fm:forge3");
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run particle mob:flame ~ ~0.7 ~`);
        block.dimension.playSound("block.furnace.lit", block.center());        
        });}
        }
        if (block.typeId === 'fm:forge3') {
            if (item.typeId === 'mob:rune_block') {
        system.run(() => {
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p mob:rune_block 0 1`);              
        block.setType("fm:forge4");
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run particle mob:flame ~ ~0.7 ~`);
        block.dimension.playSound("block.furnace.lit", block.center());        
        });}
        }
        if (block.typeId === 'fm:forge4') {
            if (item.typeId === 'fm:magic_singularity') {
        system.run(() => {
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:magic_singularity 0 1`);                 
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run particle mob:flame ~ ~0.7 ~`);
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run function forge`);
        block.dimension.playSound("random.fizz", block.center());      

//Salt

        });}
        }
        if (block.typeId === 'fm:salt_2') {
            if (item.typeId === 'fm:armor_search') {
        system.run(() => {
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:armor_search 0 1`);            
        block.setType("fm:salt_armor");
        });}
        }
        if (block.typeId === 'fm:salt_armor') {
            if (item.typeId === 'minecraft:purple_dye') {
        system.run(() => {
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p purple_dye 0 1`);            
        block.setType("fm:salt_p");
        });}
        }
        if (block.typeId === 'fm:salt_armor') {
            if (item.typeId === 'minecraft:black_dye') {
        system.run(() => {
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p black_dye 0 1`);            
        block.setType("fm:salt_b");
        });}
        }
        if (block.typeId === 'fm:salt_armor') {
            if (item.typeId === 'minecraft:brown_dye') {
        system.run(() => {
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p brown_dye 0 1`);            
        block.setType("fm:salt_brown");
        
//purple    

        });}
        }
        if (block.typeId === 'fm:salt_p') {
            if (item.typeId === 'minecraft:iron_chestplate') {
        system.run(() => {
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p iron_chestplate 0 1`);            
        block.setType("fm:salt_p2");
        });}
        }
        if (block.typeId === 'fm:salt_p2') {
            if (item.typeId === 'minecraft:iron_helmet') {
        system.run(() => {
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p iron_helmet 0 1`);
        block.setType("fm:salt_p3");
        });}
        }
        if (block.typeId === 'fm:salt_p3') {
            if (item.typeId === 'minecraft:iron_boots') {
        system.run(() => {
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p iron_boots 0 1`);            
        block.setType("minecraft:air");
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run function ars2`);

//Black 

        });}
        }
        if (block.typeId === 'fm:salt_b') {
            if (item.typeId === 'minecraft:iron_chestplate') {
        system.run(() => {
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p iron_chestplate 0 1`);            
        block.setType("fm:salt_b2");
        });}
        }
        if (block.typeId === 'fm:salt_b2') {
            if (item.typeId === 'minecraft:iron_helmet') {
        system.run(() => {
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p iron_helmet 0 1`);            
        block.setType("fm:salt_b3");
        });}
        }
        if (block.typeId === 'fm:salt_b3') {
            if (item.typeId === 'minecraft:iron_boots') {
        system.run(() => {
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p iron_boots 0 1`);            
        block.setType("minecraft:air");
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run function ars`);
        
//brown

        });}
        }
        if (block.typeId === 'fm:salt_brown') {
            if (item.typeId === 'minecraft:iron_chestplate') {
        system.run(() => {
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p iron_chestplate 0 1`);            
        block.setType("fm:salt_brown2");
        });}
        }
        if (block.typeId === 'fm:salt_brown2') {
            if (item.typeId === 'minecraft:iron_helmet') {
        system.run(() => {
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p iron_helmet 0 1`);            
        block.setType("fm:salt_brown3");
        });}
        }
        if (block.typeId === 'fm:salt_brown3') {
            if (item.typeId === 'minecraft:iron_boots') {
        system.run(() => {
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p iron_boots 0 1`);            
        block.setType("minecraft:air");
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run function ars3`);
        
//Void extractor on        
        
        });}
        }
        if (block.typeId === 'fm:void_extractor') {
            if (item.typeId === 'fm:e_aura') {
        system.run(() => {
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run clear @p fm:e_aura 0 1`);                 
        block.setType("fm:void_extractor_on");
        block.dimension.spawnParticle("mob:block_on", block.center());
        block.dimension.spawnParticle("mob:block_on", block.center());
        block.dimension.spawnParticle("mob:block_on", block.center());
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run summon mob:item_empty_aura2 ~ ~-0.5 ~`);
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run summon mob:tp ~ ~-0.5 ~`);
        });}
        }
        if (block.typeId === 'fm:void_extractor_result') {
        system.run(() => {
        block.setType("fm:void_extractor");
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run give @p fm:essence_of_void`);
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run tp @e[type=mob:item_empty_aura2,r=1] ~ ~-1000~`);
        player.dimension.runCommandAsync(`execute positioned ${block.location.x} ${block.location.y} ${block.location.z} run summon fm:kill2 ~ ~-1000 ~`);
        });
      }
    }
  });
});
